; Copyleft (c) n/a-n/a Azure Zanculmarktum

!define FILENAME    "PowerISO_Portable_${VER}_${APPLANG}"
!define APPNAME     "PowerISO"
!define APP         "PowerISO"
!define APPVER      "6.1.0.0"
!define VER         "6.1"
!define APPLANG     "Multilingual"
!define FOLDER      "PowerISOPortable"
!define LAUNCHER    "PowerISOPortable"
!define APPDIR      "PowerISO"
!define APPDIR64    "${APPDIR}64"
!define APPINFO
	!define PUBLISHER    "Power Software Ltd"
	!define HOMEPAGE     "http://www.google.com/search?q=${FILENAME}.paf"
	!define CATEGORY     "Utilities"
	!define DESCRIPTION  "Open, burn, create, edit, compress, encrypt and extract ISO files"
	!define LANGUAGE     "Multilingual"
!define HELP
!define SOURCE
!define INIT
!define COMPONENTS

; === Best Compression ===
SetCompress Auto
SetCompressor /SOLID lzma
SetCompressorDictSize 32
SetDatablockOptimize On

; === Include ===
!include Include\Installer.nsh

Section "${APPNAME} Portable x86" Main
	SetDetailsPrint textonly
	DetailPrint "Extracting ${APPNAME} Portable..."
	SetDetailsPrint listonly
	SetDetailsView hide

	SectionIn RO

	SetOutPath "$INSTDIR"
		File "..\..\${LAUNCHER}.exe"
	SetOutPath "$INSTDIR\App\${APPDIR}"
		File /r /x thumbs.db "..\..\App\${APPDIR}\*.*"

	Call AppInfo

	Call Help

	Call Source
SectionEnd

Section /o "${APPNAME} Portable x64" x64
	SetDetailsPrint textonly
	DetailPrint "Extracting ${APPNAME} Portable..."
	SetDetailsPrint listonly
	SetDetailsView hide

	SetOutPath "$INSTDIR"
		File "..\..\${LAUNCHER}.exe"
	SetOutPath "$INSTDIR\App\${APPDIR64}"
		File /r /x thumbs.db "..\..\App\${APPDIR64}\*.*"

	Call AppInfo

	Call Help

	Call Source
SectionEnd

!ifdef INIT
	Function Init
		; === Destroy size lol ===
		SectionSetSize ${Main} 0
		SectionSetSize ${x64} 0

		; === Auto select x64 if running on x64 machine ===
		System::Call `kernel32::GetCurrentProcess()i.s`
		System::Call `kernel32::IsWow64Process(is,*i.s)`
		Pop $0
		StrCmp $0 "1" "" +2
			SectionSetFlags ${x64} 1
	FunctionEnd
!endif
